function [A,E] = linearco(x,overlap,width)
% [A,E] = linearco(x,overlap,width)
%
% This function performs an LPC analisis on signal 'x' by means of a fix length window
% of 'width' samples with and overlap between them of 'overlap' samples.
% It returns the modified signal on E and the LPC coeficients on A.
%
% (c) 2005 - Ana Huerta (eNTERFACE Workshop)
%

window=hamming(2*overlap);
left=window(1:length(window)/2);
right=window((length(window)/2)+1:length(window));
win=[left',ones(1,(width-2*overlap)),right'];
%win=win';
inicio=1;
extrem=inicio+width;
A=[];
E=zeros(1,length(x));
resfil=[];

while(extrem<length(x))
    segment=x(inicio:(extrem-1));
    energy=sum(segment.^2);
    em=energy/length(segment);    
    segment(1:overlap)=segment(1:overlap).*left;
    segment((length(segment)-overlap+1):(length(segment)))=segment((length(segment)-overlap+1):(length(segment))).*right;
    coeficientes=lpc(segment',10);
    err=filter(coeficientes', 1, segment);
    
    res=modifres(err,energy,em); %modify res
        
    resfil=filter(1,coeficientes', res);
    offset=zeros(1,inicio);
    resfil=[offset,resfil'];
    
    for i=inicio:(length(resfil))
        E(i)=E(i)+resfil(i);
    end
    
    A=[A,coeficientes];
       
    inicio=extrem-overlap;
    extrem=inicio+width;
end

weje=E;


  
    
    